/*
 * Decompiled with CFR 0.152.
 */
package it.blocksy;

import it.blocksy.VoteChecker;
import it.blocksy.api.UpdateChecker;
import it.blocksy.config.ConfigManager;
import org.bukkit.plugin.java.JavaPlugin;

public final class Blocksy
extends JavaPlugin {
    private static Blocksy instance;
    private ConfigManager configManager;
    private VoteChecker voteChecker;

    public void onEnable() {
        instance = this;
        this.configManager = new ConfigManager(this);
        this.saveDefaultConfig();
        this.configManager.loadConfig();
        this.startVotePolling();
        if (this.getCommand("blocksy") != null) {
            this.getCommand("blocksy").setExecutor((sender, command, label, args) -> {
                if (!sender.hasPermission("blocksy.admin")) {
                    sender.sendMessage("\u00a7cNon hai i permessi per usare questo comando.");
                    return true;
                }
                if (args.length > 0 && args[0].equalsIgnoreCase("reload")) {
                    this.reloadPolling();
                    sender.sendMessage("\u00a7a[Blocksy] Configurazione ricaricata e polling riavviato!");
                    return true;
                }
                sender.sendMessage("\u00a7eUso: /blocksy reload");
                return true;
            });
        }
        this.getLogger().info("\u00a7aBlocksy Vote Plugin abilitato con successo!");
        this.getLogger().info("\u00a7aVersione: " + this.getDescription().getVersion());
        this.getLogger().info("\u00a7aAutore: " + (String)this.getDescription().getAuthors().get(0));
        new UpdateChecker(this).check();
    }

    public void onDisable() {
        if (this.voteChecker != null) {
            this.voteChecker.stop();
        }
        this.getLogger().info("\u00a7cBlocksy Vote Plugin disabilitato!");
    }

    private void startVotePolling() {
        String apiKey = this.getConfig().getString("api-key", "");
        int checkInterval = this.getConfig().getInt("check-interval", 5);
        if (apiKey.isEmpty()) {
            this.getLogger().warning("\u00a7c===========================================");
            this.getLogger().warning("\u00a7cAPI KEY NON CONFIGURATA!");
            this.getLogger().warning("\u00a7cConfigura 'api-key' in config.yml");
            this.getLogger().warning("\u00a7cIl sistema di voti non funzioner\u00e0!");
            this.getLogger().warning("\u00a7c===========================================");
            return;
        }
        this.getLogger().info("\u00a7eAvvio sistema di polling voti...");
        this.getLogger().info("\u00a7eAPI Key: " + apiKey.substring(0, Math.min(8, apiKey.length())) + "...");
        this.getLogger().info("\u00a7eIntervallo controllo: " + checkInterval + " secondi");
        this.voteChecker = new VoteChecker(this, apiKey, checkInterval);
        this.voteChecker.start();
    }

    public void reloadPolling() {
        if (this.voteChecker != null) {
            this.voteChecker.stop();
        }
        this.configManager.reloadConfig();
        this.startVotePolling();
    }

    public static Blocksy getInstance() {
        return instance;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public VoteChecker getVoteChecker() {
        return this.voteChecker;
    }
}

