/*
 * Decompiled with CFR 0.152.
 */
package it.blocksy;

import com.vexsoftware.votifier.model.Vote;
import com.vexsoftware.votifier.model.VotifierEvent;
import it.blocksy.Blocksy;
import it.blocksy.api.BlocksyAPI;
import it.blocksy.api.BlocksyVote;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class VoteChecker {
    private final Blocksy plugin;
    private final BlocksyAPI api;
    private final String apiKey;
    private final int checkInterval;
    private BukkitTask task;
    private boolean running;

    public VoteChecker(Blocksy plugin, String apiKey, int checkInterval) {
        this.plugin = plugin;
        this.api = new BlocksyAPI();
        this.apiKey = apiKey;
        this.checkInterval = checkInterval;
        this.running = false;
    }

    public void start() {
        if (this.running) {
            return;
        }
        this.running = true;
        this.plugin.getLogger().info("Avvio sistema di polling voti...");
        this.plugin.getLogger().info("Controllo ogni " + this.checkInterval + " secondi");
        long intervalTicks = (long)this.checkInterval * 20L;
        boolean isFolia = false;
        try {
            Class.forName("io.papermc.paper.threadedregions.RegionSerializer");
            isFolia = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (isFolia) {
            this.plugin.getLogger().info("Rilevato ambiente Folia. Utilizzo GlobalRegionScheduler.");
            Bukkit.getGlobalRegionScheduler().runAtFixedRate((Plugin)this.plugin, task -> this.checkForVotes(), 20L, intervalTicks);
        } else {
            this.task = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, () -> this.checkForVotes(), 20L, intervalTicks);
        }
    }

    public void stop() {
        if (!this.running) {
            return;
        }
        this.running = false;
        if (this.task != null) {
            this.task.cancel();
            this.task = null;
        }
        this.plugin.getLogger().info("Sistema di polling voti fermato");
    }

    private void checkForVotes() {
        try {
            List<BlocksyVote> votes = this.api.fetchVotes(this.apiKey);
            if (votes.isEmpty()) {
                return;
            }
            this.plugin.getLogger().info("Trovati " + votes.size() + " voti pendenti");
            for (BlocksyVote vote : votes) {
                this.processVote(vote);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Errore nel controllo voti: " + e.getMessage());
        }
    }

    private void processVote(BlocksyVote vote) {
        try {
            this.plugin.getLogger().info("Processando voto: " + vote.getUsername() + " (ID: " + vote.getId() + ")");
            Vote votifierVote = new Vote();
            votifierVote.setUsername(vote.getUsername());
            votifierVote.setServiceName("Blocksy");
            votifierVote.setAddress("blocksy.it");
            votifierVote.setTimeStamp(vote.getTimestamp());
            boolean isFolia = false;
            try {
                Class.forName("io.papermc.paper.threadedregions.RegionSerializer");
                isFolia = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            Runnable eventTask = () -> {
                try {
                    VotifierEvent event = new VotifierEvent(votifierVote);
                    Bukkit.getPluginManager().callEvent((Event)event);
                    this.plugin.getLogger().info("\u2713 Voto inviato a Votifier per " + vote.getUsername());
                }
                catch (Exception e) {
                    this.plugin.getLogger().severe("\u2717 Errore nell'invio evento Votifier: " + e.getMessage());
                }
            };
            if (isFolia) {
                Bukkit.getGlobalRegionScheduler().execute((Plugin)this.plugin, eventTask);
            } else {
                Bukkit.getScheduler().runTask((Plugin)this.plugin, eventTask);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Errore nel processare voto ID " + vote.getId() + ": " + e.getMessage());
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public int getCheckInterval() {
        return this.checkInterval;
    }
}

