/*
 * Decompiled with CFR 0.152.
 */
package it.blocksy.api;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import it.blocksy.api.BlocksyVote;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class BlocksyAPI {
    private static final String API_URL = "https://www.blocksy.it/api/vote/fetch";
    private static final int TIMEOUT = 10000;
    private final Gson gson = new Gson();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BlocksyVote> fetchVotes(String apiKey) {
        HttpURLConnection connection = null;
        try {
            String line;
            String urlString = "https://www.blocksy.it/api/vote/fetch?apiKey=" + apiKey;
            URL url = new URL(urlString);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            connection.setRequestProperty("User-Agent", "Blocksy-Plugin/1.0");
            connection.setRequestProperty("Accept", "application/json");
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                throw new Exception("HTTP " + responseCode + ": " + connection.getResponseMessage());
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            StringBuilder response = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
            reader.close();
            Type listType = new TypeToken<List<BlocksyVote>>(this){}.getType();
            List votes = (List)this.gson.fromJson(response.toString(), listType);
            List list = votes != null ? votes : new ArrayList();
            return list;
        }
        catch (Exception e) {
            System.err.println("Errore nel recupero voti: " + e.getMessage());
            ArrayList<BlocksyVote> arrayList = new ArrayList<BlocksyVote>();
            return arrayList;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }
}

