/*
 * Decompiled with CFR 0.152.
 */
package it.blocksy.api;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import it.blocksy.Blocksy;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class UpdateChecker {
    private final JavaPlugin plugin;
    private final String apiUrl = "https://www.blocksy.it/api/plugin_check.php";
    private final Gson gson = new Gson();

    public UpdateChecker(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public void check() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                String latestVersion;
                String line;
                String currentVersion = this.plugin.getDescription().getVersion();
                HttpURLConnection connection = (HttpURLConnection)new URL("https://www.blocksy.it/api/plugin_check.php").openConnection();
                connection.setRequestMethod("GET");
                connection.setConnectTimeout(5000);
                connection.setReadTimeout(5000);
                connection.setRequestProperty("User-Agent", "Blocksy-Plugin-Updater");
                if (connection.getResponseCode() != 200) {
                    return;
                }
                BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                StringBuilder response = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
                reader.close();
                JsonObject json = this.gson.fromJson(response.toString(), JsonObject.class);
                if (json.has("success") && json.get("success").getAsBoolean() && !(latestVersion = json.get("latest_version").getAsString()).equalsIgnoreCase(currentVersion)) {
                    String jarName = json.get("jar_name").getAsString();
                    String changelog = json.has("changelog") ? json.get("changelog").getAsString() : "Miglioramenti generali";
                    String downloadUrl = json.get("download_url").getAsString();
                    this.plugin.getLogger().info("====================================================");
                    this.plugin.getLogger().info("NUOVO AGGIORNAMENTO DISPONIBILE!");
                    this.plugin.getLogger().info("Attuale: " + currentVersion + " | Disponibile: " + latestVersion);
                    this.plugin.getLogger().info("Scarica: " + downloadUrl);
                    this.plugin.getLogger().info("====================================================");
                    this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> Bukkit.getPluginManager().registerEvents((Listener)new UpdateNotifyListener(latestVersion, changelog, downloadUrl), (Plugin)this.plugin));
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().info("Impossibile contattare il server per il controllo aggiornamenti.");
            }
        });
    }

    private static class UpdateNotifyListener
    implements Listener {
        private final String version;
        private final String changelog;
        private final String url;

        public UpdateNotifyListener(String version, String changelog, String url) {
            this.version = version;
            this.changelog = changelog;
            this.url = url;
        }

        @EventHandler
        public void onJoin(PlayerJoinEvent event) {
            Player player = event.getPlayer();
            if (player.isOp() || player.hasPermission("blocksy.admin")) {
                Bukkit.getScheduler().runTaskLater((Plugin)Blocksy.getInstance(), () -> {
                    player.sendMessage("");
                    player.sendMessage("\u00a7b\u00a7lBlocksy \u00a78\u00bb \u00a7e\u00c8 disponibile una nuova versione! \u00a77(\u00a7f" + this.version + "\u00a77)");
                    player.sendMessage("\u00a7b\u00a7lBlocksy \u00a78\u00bb \u00a77Changelog: \u00a7f" + this.changelog);
                    player.sendMessage("\u00a7b\u00a7lBlocksy \u00a78\u00bb \u00a77Scarica qui: \u00a7b\u00a7n" + this.url);
                    player.sendMessage("");
                }, 60L);
            }
        }
    }
}

